@REM @file
@REM  Pre build script.
@REM
@REM @copyright
@REM  INTEL CONFIDENTIAL
@REM  Copyright 2010 - 2018 Intel Corporation.
@REM
@REM  The source code contained or described herein and all documents related to the
@REM  source code ("Material") are owned by Intel Corporation or its suppliers or
@REM  licensors. Title to the Material remains with Intel Corporation or its suppliers
@REM  and licensors. The Material may contain trade secrets and proprietary and
@REM  confidential information of Intel Corporation and its suppliers and licensors,
@REM  and is protected by worldwide copyright and trade secret laws and treaty
@REM  provisions. No part of the Material may be used, copied, reproduced, modified,
@REM  published, uploaded, posted, transmitted, distributed, or disclosed in any way
@REM  without Intel's prior express written permission.
@REM
@REM  No license under any patent, copyright, trade secret or other intellectual
@REM  property right is granted to or conferred upon you by disclosure or delivery
@REM  of the Materials, either expressly, by implication, inducement, estoppel or
@REM  otherwise. Any license under such intellectual property rights must be
@REM  express and approved by Intel in writing.
@REM
@REM  Unless otherwise agreed by Intel in writing, you may not remove or alter
@REM  this notice or any other notice embedded in Materials by Intel or
@REM  Intel's suppliers or licensors in any way.
@REM
@REM  This file contains a 'Sample Driver' and is licensed as such under the terms
@REM  of your license agreement with Intel or your vendor. This file may be modified
@REM  by the user, subject to the additional terms of the license agreement.
@REM
@REM @par Specification Reference:
@REM

cd ..


@REM
@REM Set build capsule flag with default being OFF
@REM

@set CAPSULE_BUILD=0

@if /I "%2" == "TRUE" (
  @set CAPSULE_BUILD=1
  goto StartCapsulePrep
)

:StartCapsulePrep
@REM
@REM Define platform specific environment variables.
@REM
@set PLATFORM_PACKAGE=KabylakePlatSamplePkg
@set CLIENT_COMMON_PACKAGE=ClientCommonPkg
@set BP_COMMON_PACKAGE=BpCommonPkg
set WORKSPACE_PLATFORM=%CD%
set WORKSPACE_SILICON=%WORKSPACE_PLATFORM%
set WORKSPACE_CORE=%WORKSPACE_PLATFORM%
set WORKSPACE=%WORKSPACE_PLATFORM%
set PACKAGES_PATH=%WORKSPACE_CORE%;%WORKSPACE_PLATFORM%;%WORKSPACE_SILICON%
set EDK_TOOLS_BIN=%WORKSPACE_CORE%\BaseTools\Bin\Win32

@REM
@REM RPPO-KBL-0093: RoyalParkOverrideBegin
@REM
@set BASE_TOOLS=BaseToolsTmp

@if not exist %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\Override\BaseTools goto SkipBaseToolsOverriding
@if not exist %WORKSPACE%\%BASE_TOOLS% (
  xcopy /i /s /y %WORKSPACE_CORE%\BaseTools\*.* %WORKSPACE%\%BASE_TOOLS%\ > NUL
)

@echo %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\Override\BaseTools\
@echo %WORKSPACE%\%BASE_TOOLS%\

xcopy /i /s /y %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\Override\BaseTools\Source\C\Common\Decompress.c %WORKSPACE%\%BASE_TOOLS%\Source\C\Common\ > NUL
xcopy /i /s /y %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\Override\BaseTools\Source\C\TianoCompress\TianoCompress.c %WORKSPACE%\%BASE_TOOLS%\Source\C\TianoCompress\ > NUL

echo %PATH% | find /I "%WORKSPACE_CORE%\BaseTools\Bin;" > NUL

@if /I not "%EDK_TOOLS_PATH%" == "%WORKSPACE%\%BASE_TOOLS%" (
  @set EDK_TOOLS_PATH=%WORKSPACE%\%BASE_TOOLS%
)

@set PATH=%EDK_TOOLS_PATH%\Bin;%EDK_TOOLS_PATH%\Bin\Win32;%PATH%
@echo Overridden EDK_TOOLS_PATH = %EDK_TOOLS_PATH%

:SkipBaseToolsOverriding

@REM
@REM RPPO-KBL-0093: RoyalParkOverrideEnd
@REM

@set SCRIPT_ERROR=0

copy %WORKSPACE_PLATFORM%\KabylakePlatSamplePkg\Tools\Conf\tools_def.template Conf\tools_def.txt /Y

@REM ROYAL_PARK_OVERRIDE: RoyalParkOverrideBegin - RPPO-KBL-0035
@REM
@REM AdvancedFeaturesBegin
@REM
attrib Conf\tools_def.txt -r
@if /I "%1" == "RELEASE_PDB" (
  copy %WORKSPACE_PLATFORM%\KabylakePlatSamplePkg\Override\BaseTools\Conf\tools_def_pdb.template Conf\tools_def.txt /Y
) else (
  copy %WORKSPACE_PLATFORM%\KabylakePlatSamplePkg\Override\BaseTools\Conf\tools_def.template Conf\tools_def.txt /Y
)
@REM
@REM AdvancedFeaturesEnd
@REM
copy %WORKSPACE_PLATFORM%\KabylakePlatSamplePkg\Override\BaseTools\Conf\build_rule.template Conf\build_rule.txt /Y

@REM ROYAL_PARK_OVERRIDE: RoyalParkOverrideEnd

@set CATALOG_DEBUG=0
@type %WORKSPACE_PLATFORM%\KabylakePlatSamplePkg\PlatformPkgExtConfig.dsc | findstr /V "^[^0-9,a-z]*#" | find "gClientCommonModuleTokenSpaceGuid.PcdCatalogDebugEnable" > NUL
@if not errorlevel 1 (
  @type %WORKSPACE_PLATFORM%\KabylakePlatSamplePkg\PlatformPkgExtConfig.dsc | findstr /V "^[^0-9,a-z]*#" | find "gClientCommonModuleTokenSpaceGuid.PcdCatalogDebugEnable|TRUE" > NUL
  @if not errorlevel 1 (
    @set CATALOG_DEBUG=1
  )
) else (
  @type %WORKSPACE_PLATFORM%\KabylakePlatSamplePkg\PlatformPkgConfig.dsc | findstr /V "^[^0-9,a-z]*#" | find "gClientCommonModuleTokenSpaceGuid.PcdCatalogDebugEnable|TRUE" > NUL
  @if not errorlevel 1 (
    @set CATALOG_DEBUG=1
  ) else (
    @type %WORKSPACE_PLATFORM%\KabylakePlatSamplePkg\PlatformPkgConfig.dsc | findstr /V "^[^0-9,a-z]*#" | find "gClientCommonModuleTokenSpaceGuid.PcdCatalogDebugEnable|FALSE" > NUL
    @if errorlevel 1 (
      @type %WORKSPACE_CORE%\ClientCommonPkg\ClientCommonPkg.dec | findstr /V "^[^0-9,a-z]*#" | find "gClientCommonModuleTokenSpaceGuid.PcdCatalogDebugEnable|TRUE" > NUL
      @if not errorlevel 1 (
        @set CATALOG_DEBUG=1
      )
    )
  )
)
@if %CATALOG_DEBUG% == 1 (
  @if exist c:\python27 (
    set PYTHON_DIR=c:\python27
    copy %WORKSPACE_CORE%\ClientCommonPkg\Override\BaseTools\Conf\build_rule_catalog.template Conf\build_rule.txt /Y
  ) else (
    echo.
    echo !!! ERROR !!! Python27 not installed correctly!!!
    echo.
    set SCRIPT_ERROR=1
    goto :EndPreBuild
  )
)

@REM Set basic environment.
@echo.
@echo Prebuild:  Run edksetup.bat batch file.
@echo.
@if %CATALOG_DEBUG% == 0 (
  @del Conf\build_rule.txt
)
cd %WORKSPACE_CORE%
@call edksetup.bat
cd %WORKSPACE%
@if not defined WORKSPACE_ADDITIONAL_TOOLS_PATH (
  @set WORKSPACE_ADDITIONAL_TOOLS_PATH=%WORKSPACE_CORE%\%CLIENT_COMMON_PACKAGE%\Override\BpCommonPkg\Tools\FCE;%WORKSPACE_CORE%\%CLIENT_COMMON_PACKAGE%\Override\BpCommonPkg\Tools\FMMT;%WORKSPACE_CORE%\%BP_COMMON_PACKAGE%\Tools\KeyEnroll;%WORKSPACE_CORE%\%BP_COMMON_PACKAGE%\Tools\SignFv;%WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\Tools\ToolScripts\SignFv
  goto SetAdditionalPath
) else (
  goto SetNormalPath
)

:SetAdditionalPath
@set PATH=%WORKSPACE_ADDITIONAL_TOOLS_PATH%;%PATH%

:SetNormalPath
@set EFI_SOURCE=%WORKSPACE_CORE%

@REM
@REM Setup Visual Studio environment. Order of precedence is 2012, 2013, 2010 and then 2008.
@REM
@REM NOTE: To override precedence set TOOL_CHAIN_TAG before calling prep.bat.
@REM       Example: set TOOL_CHAIN_TAG=VS2008
@REM

@REM Check if tool chain has not been selected and Visual Studio 2014 is installed.
@if not defined TOOL_CHAIN_TAG (
  if defined VS140COMNTOOLS (
    set TOOL_CHAIN_TAG=VS2015
  )
)

@REM If Visual Studio 2014 is selected by priority or by preference, setup the environment variables.
@if /I "%TOOL_CHAIN_TAG%"=="VS2015" (
  echo.
  echo Prebuild:  Set the VS2015 environment.
  echo.
  if not defined VSINSTALLDIR call "%VS140COMNTOOLS%\vsvars32.bat"
  if /I "%VS140COMNTOOLS%" == "C:\Program Files\Microsoft Visual Studio 14.0\Common7\Tools\" (
    set TOOL_CHAIN_TAG=VS2015
  ) else (
    set TOOL_CHAIN_TAG=VS2015x86
  )
)

@REM Check if tool chain has not been selected and Visual Studio 2013 is installed.
@if not defined TOOL_CHAIN_TAG (
  if defined VS120COMNTOOLS (
    set TOOL_CHAIN_TAG=VS2013
  )
)

@REM If Visual Studio 2013 is selected by priority or by preference, setup the environment variables.
@if /I "%TOOL_CHAIN_TAG%"=="VS2013" (
  echo.
  echo Prebuild:  Set the VS2013 environment.
  echo.
  if not defined VSINSTALLDIR call "%VS120COMNTOOLS%\vsvars32.bat"
  if /I "%VS120COMNTOOLS%" == "C:\Program Files\Microsoft Visual Studio 12.0\Common7\Tools\" (
    set TOOL_CHAIN_TAG=VS2013
  ) else (
    set TOOL_CHAIN_TAG=VS2013x86
  )
)

@REM If no supported version of Visual Studio was detected, return an error.
@if not defined TOOL_CHAIN_TAG (
  echo.
  echo !!! ERROR !!! Visual Studio not installed correctly!!!
  echo.
  set SCRIPT_ERROR=1
  goto :EndPreBuild
)

echo Show CL revision
cl

@REM Set build TARGET.
@if /I "%1" == "" (
  set TARGET=DEBUG
  set TARGET_SHORT=D
) else if /I "%1" == "DEBUG" (
  set TARGET=DEBUG
  set TARGET_SHORT=D
) else if /I "%1" == "TEST_RELEASE" (
  set TARGET=RELEASE
  set TARGET_SHORT=R
) else if /I "%1" == "RELEASE" (
  set TARGET=RELEASE
  set TARGET_SHORT=R
) else if /I "%1" == "RELEASE_PDB" (
  set TARGET=RELEASE
  set TARGET_SHORT=R
) else (
  echo.
  echo !!! ERROR !!! Incorrect TARGET option for prebuild.bat. !!!
  echo.
  set SCRIPT_ERROR=1
  goto :EndPreBuild
)

@set BUILD_DIR_PATH=%WORKSPACE%\Build\%PLATFORM_PACKAGE%\%TARGET%_%TOOL_CHAIN_TAG%
@set ROM_IMAGES_DIR_PATH=%WORKSPACE%\RomImages
@set BUILD_DIR=Build\%PLATFORM_PACKAGE%\%TARGET%_%TOOL_CHAIN_TAG%
@set BUILD_X64=%BUILD_DIR_PATH%\X64
@set BUILD_IA32=%BUILD_DIR_PATH%\IA32

@REM
@REM AdvancedFeaturesBegin
@REM
@set ASL_TOOLS_DIR=%WORKSPACE_CORE%\ClientCommonPkg\Tools\Iasl
@REM
@REM AdvancedFeaturesEnd
@REM

@echo.
@echo Prebuild:  Set build environment.
@echo.
@if not exist %BUILD_DIR_PATH% (
  mkdir %BUILD_DIR_PATH%
)

@findstr /V "ACTIVE_PLATFORM TARGET TARGET_ARCH TOOL_CHAIN_TAG BUILD_RULE_CONF" Conf\target.txt > %BUILD_DIR_PATH%\target.txt
@if %CAPSULE_BUILD% == 0 (
  @echo ACTIVE_PLATFORM = %PLATFORM_PACKAGE%/PlatformPkg.dsc      >> %BUILD_DIR_PATH%\target.txt
) else (
  @echo ACTIVE_PLATFORM = %PLATFORM_PACKAGE%/CapsulePkg.dsc       >> %BUILD_DIR_PATH%\target.txt
)
@echo TARGET          = %TARGET%                                  >> %BUILD_DIR_PATH%\target.txt
@echo TARGET_ARCH     = IA32 X64                                  >> %BUILD_DIR_PATH%\target.txt
@echo TOOL_CHAIN_TAG  = %TOOL_CHAIN_TAG%                          >> %BUILD_DIR_PATH%\target.txt
@echo BUILD_RULE_CONF = Conf/build_rule.txt                       >> %BUILD_DIR_PATH%\target.txt
@move /Y %BUILD_DIR_PATH%\target.txt Conf

@if %CAPSULE_BUILD% == 1 (
  goto EndCapsulePrep
)

@REM
@REM Set %FSP_WRAPPER_BUILD%
@REM
@set FSP_WRAPPER_BUILD=FALSE
@type %WORKSPACE_PLATFORM%\KabylakePlatSamplePkg\PlatformPkgExtConfig.dsc | findstr /V "^[^0-9,a-z]*#" | find "gPlatformModuleTokenSpaceGuid.PcdFspWrapperEnable" > NUL
@if not errorlevel 1 (
  @type %WORKSPACE_PLATFORM%\KabylakePlatSamplePkg\PlatformPkgExtConfig.dsc | findstr /V "^[^0-9,a-z]*#" | find "gPlatformModuleTokenSpaceGuid.PcdFspWrapperEnable|TRUE" > NUL
  @if not errorlevel 1 (
    set FSP_WRAPPER_BUILD=TRUE
  )
) else (
  @type %WORKSPACE_PLATFORM%\KabylakePlatSamplePkg\PlatformPkgConfig.dsc | findstr /V "^[^0-9,a-z]*#" | find "gPlatformModuleTokenSpaceGuid.PcdFspWrapperEnable|TRUE" > NUL
  @if not errorlevel 1 (
    set FSP_WRAPPER_BUILD=TRUE
  )
)

@if %FSP_WRAPPER_BUILD% EQU TRUE (
  @REM Create dummy Fsp_Rebased_S_padded.fd to build the BiosInfo.inf if it is wrapper build, due to the SECTION inclusion
  echo "" > %WORKSPACE_SILICON%\KabylakeFspBinPkg\Fsp_Rebased_S_padded.fd
  attrib -r %WORKSPACE_SILICON%\KabylakeFspBinPkg\Fsp_Rebased_S_padded.fd
)

@REM
@REM Set %PERFORMANCE_BUILD%
@REM
@set PERFORMANCE_BUILD=FALSE
@type KabylakePlatSamplePkg\PlatformPkgExtConfig.dsc | findstr /V "^[^0-9,a-z]*#" | find "gPlatformModuleTokenSpaceGuid.PcdPerformanceEnable" > NUL
@if not errorlevel 1 (
  @type KabylakePlatSamplePkg\PlatformPkgExtConfig.dsc | findstr /V "^[^0-9,a-z]*#" | find "gPlatformModuleTokenSpaceGuid.PcdPerformanceEnable|TRUE" > NUL
  @if not errorlevel 1 (
    set PERFORMANCE_BUILD=TRUE
  )
) else (
  @type KabylakePlatSamplePkg\PlatformPkgConfig.dsc | findstr /V "^[^0-9,a-z]*#" | find "gPlatformModuleTokenSpaceGuid.PcdPerformanceEnable|TRUE" > NUL
  @if not errorlevel 1 (
    set PERFORMANCE_BUILD=TRUE
  )
)

@REM
@REM Set %FSP_BINARY_BUILD% and %FSP_TEST_RELEASE%
@REM
@set FSP_BINARY_BUILD=FALSE
@set FSP_TEST_RELEASE=FALSE
@type %WORKSPACE_PLATFORM%\KabylakePlatSamplePkg\PlatformPkgExtConfig.dsc | findstr /V "^[^0-9,a-z]*#" | find "gPlatformModuleTokenSpaceGuid.PcdFspBinaryEnable" > NUL
@if not errorlevel 1 (
  @type %WORKSPACE_PLATFORM%\KabylakePlatSamplePkg\PlatformPkgExtConfig.dsc | findstr /V "^[^0-9,a-z]*#" | find "gPlatformModuleTokenSpaceGuid.PcdFspBinaryEnable|TRUE" > NUL
  @if not errorlevel 1 (
    set FSP_BINARY_BUILD=TRUE
    if /I "%1" == "TEST_RELEASE" (
      set FSP_TEST_RELEASE=TRUE
    )
  )
) else (
  @type %WORKSPACE_PLATFORM%\KabylakePlatSamplePkg\PlatformPkgConfig.dsc | findstr /V "^[^0-9,a-z]*#" | find "gPlatformModuleTokenSpaceGuid.PcdFspBinaryEnable|TRUE" > NUL
  @if not errorlevel 1 (
    set FSP_BINARY_BUILD=TRUE
    if /I "%1" == "TEST_RELEASE" (
      set FSP_TEST_RELEASE=TRUE
    )
  )
)

@if "FSP_BINARY_BUILD"=="TRUE" (
  @if %FSP_WRAPPER_BUILD% EQU FALSE goto :EndPreBuild
)

@echo.
@echo Prebuild:  Create BiosId.
@echo.
@if not exist %BUILD_X64% (
  mkdir %BUILD_X64%
)

@set INTERNAL_BUILD=0
@set BUILD=X
@set BIOSID_FILENAME=BiosId
@REM
@REM BUILD:  C - Code Coverage, R - RVP/Restricted, I - Internal, X - External, P - Performance, S - SV, E - SLE
@REM

@echo "set PLATFORM_SI_PACKAGE=KabylakeSiliconPkg"
set PLATFORM_SI_PACKAGE=KabylakeSiliconPkg



@type %WORKSPACE_PLATFORM%\KabylakePlatSamplePkg\PlatformPkgExtConfig.dsc | findstr /V "^[^0-9,a-z]*#" | find "gPlatformModuleTokenSpaceGuid.PcdPerformanceEnable" > NUL
@if not errorlevel 1 (
  @type %WORKSPACE_PLATFORM%\KabylakePlatSamplePkg\PlatformPkgExtConfig.dsc | findstr /V "^[^0-9,a-z]*#" | find "gPlatformModuleTokenSpaceGuid.PcdPerformanceEnable|TRUE" > NUL
  @if not errorlevel 1 (
    set BUILD=P
  )
) else (
  @type %WORKSPACE_PLATFORM%\KabylakePlatSamplePkg\PlatformPkgConfig.dsc | findstr /V "^[^0-9,a-z]*#" | find "gPlatformModuleTokenSpaceGuid.PcdPerformanceEnable|TRUE" > NUL
  @if not errorlevel 1 (
    set BUILD=P
  )
)

@set TEST_MENU_ENABLE=N
@type %WORKSPACE_PLATFORM%\KabylakePlatSamplePkg\PlatformPkgExtConfig.dsc | findstr /V "^[^0-9,a-z]*#" | find "gPlatformModuleTokenSpaceGuid.PcdTestMenuEnable" > NUL
@if not errorlevel 1 (
  @type %WORKSPACE_PLATFORM%\KabylakePlatSamplePkg\PlatformPkgExtConfig.dsc | findstr /V "^[^0-9,a-z]*#" | find "gPlatformModuleTokenSpaceGuid.PcdTestMenuEnable|TRUE" > NUL
  @if not errorlevel 1 (
    set TEST_MENU_ENABLE=Y
  )
) else (
  @type %WORKSPACE_PLATFORM%\KabylakePlatSamplePkg\PlatformPkgConfig.dsc | findstr /V "^[^0-9,a-z]*#" | find "gPlatformModuleTokenSpaceGuid.PcdTestMenuEnable|TRUE" > NUL
  @if not errorlevel 1 (
    set TEST_MENU_ENABLE=Y
  )
)

@set SECURE_BOOT_ENABLE=FALSE
@type %WORKSPACE_PLATFORM%\KabylakePlatSamplePkg\PlatformPkgExtConfig.dsc | findstr /V "^[^0-9,a-z]*#" | find "gPlatformModuleTokenSpaceGuid.PcdSecureBootEnable" > NUL
@if not errorlevel 1 (
  @type %WORKSPACE_PLATFORM%\KabylakePlatSamplePkg\PlatformPkgExtConfig.dsc | findstr /V "^[^0-9,a-z]*#" | find "gPlatformModuleTokenSpaceGuid.PcdSecureBootEnable|TRUE" > NUL
  @if not errorlevel 1 (
    set SECURE_BOOT_ENABLE=TRUE
  )
) else (
  @type %WORKSPACE_PLATFORM%\KabylakePlatSamplePkg\PlatformPkgConfig.dsc | findstr /V "^#" | find "gPlatformModuleTokenSpaceGuid.PcdSecureBootEnable|TRUE" > NUL
  @if not errorlevel 1 (
    set SECURE_BOOT_ENABLE=TRUE
  )
)


@REM
@REM Skip BIOS_SIZE_OPTION if it is predefined
@REM
@if NOT "%BIOS_SIZE_OPTION%" == "" goto BiosSizeDone

@set BIOS_SIZE_OPTION=

@REM default size option is 7M
@set BIOS_SIZE_OPTION=-DBIOS_SIZE_OPTION=SIZE_70

:BiosSizeDone
@echo BIOS_SIZE_OPTION=%BIOS_SIZE_OPTION%
@set EXT_BUILD_FLAGS=%EXT_BUILD_FLAGS% %BIOS_SIZE_OPTION%

@REM
@REM Printing the build type
@REM
@echo.
@echo Printing the build type ([U]nified, [N]on-Restricted, [I]nternal, E[x]ternal, [P]erformance, [S]V, SL[E], Code-[C]overage)
@echo Build type (%BUILD%)
@echo.

@REM
@REM Create BiosId.env based on the build type
@REM
@REM
@REM Check for Embedded build flag
@REM
set EMBEDDED_BUILD=FALSE
@type %WORKSPACE_PLATFORM%\KabylakePlatSamplePkg\PlatformPkgExtConfig.dsc | findstr /V "^[^0-9,a-z]*#" | find "gPlatformModuleTokenSpaceGuid.PcdEmbeddedEnable" > NUL
@if not errorlevel 1 (
  @type %WORKSPACE_PLATFORM%\KabylakePlatSamplePkg\PlatformPkgExtConfig.dsc | findstr /V "^[^0-9,a-z]*#" | find "gPlatformModuleTokenSpaceGuid.PcdEmbeddedEnable|TRUE" > NUL
  @if not errorlevel 1 (
    set EMBEDDED_BUILD=TRUE
  )
)
@if %EMBEDDED_BUILD% EQU FALSE goto :SkipEmbeddedBuild
@set PCH_TYPE=H
@set BIOSID_FILENAME1=BiosIdEmb
@set BIOS_ID_FILE=%BUILD_DIR_PATH%\BiosIdEmb.env
@copy %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\Tools\GenBiosId\%BIOSID_FILENAME1%.env %BIOS_ID_FILE%
echo BOARD_ID      = KBLSDBK>> %BIOS_ID_FILE%
echo BOARD_EXT     = %TARGET_SHORT%00>> %BIOS_ID_FILE%
goto :BiosIdBuild
@REM
@REM Skip for Embedded build
@REM
:SkipEmbeddedBuild
set BIOS_ID_FILE=%BUILD_DIR_PATH%\BiosId.env
copy %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\Tools\GenBiosId\%BIOSID_FILENAME%.env %BIOS_ID_FILE%
@REM
@REM SKL[S/E]: S/E=SPT/ERB
@REM

set PCH_TYPE=S
@if %FSP_WRAPPER_BUILD% EQU FALSE (
  echo BOARD_ID      = KBL%PCH_TYPE%E2%BUILD%>> %BIOS_ID_FILE%
) else (
  echo BOARD_ID      = KBL%PCH_TYPE%FW%BUILD%>> %BIOS_ID_FILE%
)

echo BOARD_EXT     = %TARGET_SHORT%00>> %BIOS_ID_FILE%

:BiosIdBuild
@set BIOS_ID_OUTPUT_DIR=%BUILD_IA32%
@if not exist %BIOS_ID_OUTPUT_DIR% mkdir %BIOS_ID_OUTPUT_DIR%
@REM
@REM AdvancedFeaturesBegin
@REM
@REM
@REM Reenable the GenBiosId if it is for external release
@REM
%WORKSPACE_CORE%\%BP_COMMON_PACKAGE%\Tools\GenBiosId\GenBiosId.exe -i %BIOS_ID_FILE% -o %BIOS_ID_OUTPUT_DIR%\BiosId.bin
@REM
@REM AdvancedFeaturesEnd
@REM


@if %ERRORLEVEL% NEQ 0 (
  set SCRIPT_ERROR=1
  goto :EndPreBuild
)


@REM
@REM AdvancedFeaturesBegin
@REM
@echo.
@echo Prebuild:  Create AutoGenFlashMap.h
@echo.
build -n %NUMBER_OF_PROCESSORS% %EXT_BUILD_FLAGS% -m %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\BiosInfo\BiosInfo.inf
@if %ERRORLEVEL% NEQ 0 (
  set SCRIPT_ERROR=1
  goto :EndPreBuild
)
@findstr /V "Base.h PiPei.h PiDxe.h PcdLib.h gEfiCallerIdGuid TOKEN const MODE EFI_CALLER_ID_GUID }} EFI_STATUS EFIAPI DummyModuleEntryPoint EFI_HANDLE EFI_SYSTEM_TABLE BiosInfoEntryPoint EFI_PEI_FILE_HANDLE EFI_PEI_SERVICES );" %BUILD_IA32%\%PLATFORM_PACKAGE%\BiosInfo\BiosInfo\DEBUG\AutoGen.h  > %BUILD_DIR_PATH%\AutoGenFlashMap.h

@echo.
@echo Prebuild:  Create BiosUpdateConfig
@echo.
@set INI_CFLAGS=/c /nologo /EP /I%WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE% /I%BUILD_DIR_PATH%
@cl %INI_CFLAGS% %WORKSPACE_PLATFORM%\%PLATFORM_PACKAGE%\CapsuleUpdateConfig\BiosUpdateConfig.ini > %BUILD_X64%\BiosUpdateConfig.tmp
@if %ERRORLEVEL% NEQ 0 (
  set SCRIPT_ERROR=1
  goto :EndPreBuild
)

@findstr /B /R [[A-Z] %BUILD_DIR_PATH%\X64\BiosUpdateConfig.tmp > %BUILD_DIR_PATH%\X64\BiosUpdateConfig.ini
@del %BUILD_DIR_PATH%\X64\BiosUpdateConfig.tmp
@REM Create the dummy ClientBios.fd file to pass first build. In post build, this image will be created.
@if not exist %BUILD_DIR_PATH%\FV (
  mkdir %BUILD_DIR_PATH%\FV
)
@echo. 2> %BUILD_DIR_PATH%\FV\ClientBios.fd
@echo. 2> %BUILD_DIR_PATH%\FV\BGUP_%TARGET%_CAPSULE.bin

:EndCapsulePrep
@echo.
@echo Prebuild is complete.
@if %CAPSULE_BUILD% == 0 (
  @echo   ACTIVE_PLATFORM      = %PLATFORM_PACKAGE%\PlatformPkg.dsc
) else (
  @echo   ACTIVE_PLATFORM      = %PLATFORM_PACKAGE%\CapsulePkg.dsc
)

@REM
@REM AdvancedFeaturesEnd
@REM

@echo   EFI_SOURCE           = %EFI_SOURCE%
@echo   TARGET               = %TARGET%
@echo   TARGET_ARCH          = IA32 X64
@echo   TOOL_CHAIN_TAG       = %TOOL_CHAIN_TAG%
@echo   WORKSPACE            = %WORKSPACE%
@echo   WORKSPACE_CORE       = %WORKSPACE_CORE%
@echo   EXT_BUILD_FLAGS      = %EXT_BUILD_FLAGS%
@echo.
:EndPreBuild
cd %WORKSPACE_PLATFORM%\KabylakePlatSamplePkg
